// SPDX-License-Identifier: GPL-2.0-only
//
// aw88081.h  --  AW88081 ALSA SoC Audio driver
//
// Copyright (c) 2024 awinic Technology CO., LTD
//
// Author: Weidong Wang <wangweidong.a@awinic.com>
//

#ifndef __AW88081_H__
#define __AW88081_H__

#define AW88081_ID_REG			(0x00)
#define AW88081_SYSST_REG		(0x01)
#define AW88081_SYSINT_REG		(0x02)
#define AW88081_SYSINTM_REG		(0x03)
#define AW88081_SYSCTRL_REG		(0x04)
#define AW88081_SYSCTRL2_REG		(0x05)
#define AW88081_I2SCTRL1_REG		(0x06)
#define AW88081_I2SCTRL2_REG		(0x07)
#define AW88081_I2SCTRL3_REG		(0x08)
#define AW88081_DACCFG1_REG		(0x09)
#define AW88081_DACCFG2_REG		(0x0A)
#define AW88081_DACCFG3_REG		(0x0B)
#define AW88081_DACCFG4_REG		(0x0C)
#define AW88081_DACCFG5_REG		(0x0D)
#define AW88081_DACCFG6_REG		(0x0E)
#define AW88081_DACCFG7_REG		(0x11)
#define AW88081_PWMCTRL1_REG		(0x13)
#define AW88081_PWMCTRL2_REG		(0x14)
#define AW88081_PWMCTRL3_REG		(0x15)
#define AW88081_PWMCTRL4_REG		(0x16)
#define AW88081_I2SCFG1_REG		(0x17)
#define AW88081_DBGCTRL_REG		(0x18)
#define AW88081_PDMCTRL_REG		(0x19)
#define AW88081_DACST_REG		(0x20)
#define AW88081_PATTERNST_REG		(0x21)
#define AW88081_I2SINT_REG		(0x26)
#define AW88081_I2SCAPCNT_REG		(0x27)
#define AW88081_ANASTA1_REG		(0x28)
#define AW88081_ANASTA2_REG		(0x29)
#define AW88081_ANASTA3_REG		(0x2A)
#define AW88081_VBAT_REG		(0x21)
#define AW88081_TEMP_REG		(0x22)
#define AW88081_PVDD_REG		(0x23)
#define AW88081_ISNDAT_REG		(0x24)
#define AW88081_VSNDAT_REG		(0x25)
#define AW88081_DSMCFG1_REG		(0x30)
#define AW88081_DSMCFG2_REG		(0x31)
#define AW88081_DSMCFG3_REG		(0x32)
#define AW88081_DSMCFG4_REG		(0x33)
#define AW88081_DSMCFG5_REG		(0x34)
#define AW88081_DSMCFG6_REG		(0x35)
#define AW88081_DSMCFG7_REG		(0x36)
#define AW88081_DSMCFG8_REG		(0x37)
#define AW88081_TESTIN_REG		(0x38)
#define AW88081_TESTOUT_REG		(0x39)
#define AW88081_BOPCTRL1_REG		(0x40)
#define AW88081_BOPCTRL2_REG		(0x41)
#define AW88081_BOPCTRL3_REG		(0x42)
#define AW88081_BOPSTA_REG		(0x43)
#define AW88081_PLLCTRL1_REG		(0x54)
#define AW88081_PLLCTRL2_REG		(0x55)
#define AW88081_PLLCTRL3_REG		(0x56)
#define AW88081_CDACTRL1_REG		(0x57)
#define AW88081_CDACTRL2_REG		(0x58)
#define AW88081_CDACTRL3_REG		(0x59)
#define AW88081_DITHERCFG1_REG		(0x5A)
#define AW88081_DITHERCFG2_REG		(0x5B)
#define AW88081_DITHERCFG3_REG		(0x5C)
#define AW88081_TM_REG			(0x6E)
#define AW88081_TM2_REG		(0x6F)
#define AW88081_TESTCTRL1_REG		(0x70)
#define AW88081_TESTCTRL2_REG		(0x71)

#define AW88081_REG_MAX		(0x72)

#define AW88081_UVLS_START_BIT		(14)
#define AW88081_UVLS_UVLO		(1)
#define AW88081_UVLS_UVLO_VALUE	\
	(AW88081_UVLS_UVLO << AW88081_UVLS_START_BIT)

#define AW88081_SWS_START_BIT		(8)
#define AW88081_SWS_SWITCHING		(1)
#define AW88081_SWS_SWITCHING_VALUE	\
	(AW88081_SWS_SWITCHING << AW88081_SWS_START_BIT)

#define AW88081_NOCLKS_START_BIT	(5)
#define AW88081_NOCLKS_NO_CLOCK	(1)
#define AW88081_NOCLKS_NO_CLOCK_VALUE	\
	(AW88081_NOCLKS_NO_CLOCK << AW88081_NOCLKS_START_BIT)

#define AW88081_CLKS_START_BIT		(4)
#define AW88081_CLKS_STABLE		(1)
#define AW88081_CLKS_STABLE_VALUE	\
	(AW88081_CLKS_STABLE << AW88081_CLKS_START_BIT)

#define AW88081_OCDS_START_BIT		(3)
#define AW88081_OCDS_OC		(1)
#define AW88081_OCDS_OC_VALUE		\
	(AW88081_OCDS_OC << AW88081_OCDS_START_BIT)

#define AW88081_OTHS_START_BIT		(1)
#define AW88081_OTHS_OT		(1)
#define AW88081_OTHS_OT_VALUE		\
	(AW88081_OTHS_OT << AW88081_OTHS_START_BIT)

#define AW88081_PLLS_START_BIT		(0)
#define AW88081_PLLS_LOCKED		(1)
#define AW88081_PLLS_LOCKED_VALUE	\
	(AW88081_PLLS_LOCKED << AW88081_PLLS_START_BIT)

#define AW88081_BIT_PLL_CHECK \
		(AW88081_CLKS_STABLE_VALUE | \
		AW88081_PLLS_LOCKED_VALUE)

#define AW88081_BIT_SYSST_CHECK_MASK \
		(~(AW88081_UVLS_UVLO_VALUE | \
		AW88081_SWS_SWITCHING_VALUE | \
		AW88081_NOCLKS_NO_CLOCK_VALUE | \
		AW88081_CLKS_STABLE_VALUE | \
		AW88081_OCDS_OC_VALUE | \
		AW88081_OTHS_OT_VALUE | \
		AW88081_PLLS_LOCKED_VALUE))

#define AW88081_NO_SWS_SYSST_CHECK \
		(AW88081_CLKS_STABLE_VALUE | \
		AW88081_PLLS_LOCKED_VALUE)

#define AW88081_SWS_SYSST_CHECK \
	(AW88081_SWS_SWITCHING_VALUE | \
	AW88081_CLKS_STABLE_VALUE | \
	AW88081_PLLS_LOCKED_VALUE)

#define AW88081_ULS_HMUTE_START_BIT	(14)
#define AW88081_ULS_HMUTE_BITS_LEN	(1)
#define AW88081_ULS_HMUTE_MASK		\
	(~(((1<<AW88081_ULS_HMUTE_BITS_LEN)-1) << AW88081_ULS_HMUTE_START_BIT))

#define AW88081_ULS_HMUTE_DISABLE	(0)
#define AW88081_ULS_HMUTE_DISABLE_VALUE	\
	(AW88081_ULS_HMUTE_DISABLE << AW88081_ULS_HMUTE_START_BIT)

#define AW88081_ULS_HMUTE_ENABLE	(1)
#define AW88081_ULS_HMUTE_ENABLE_VALUE	\
	(AW88081_ULS_HMUTE_ENABLE << AW88081_ULS_HMUTE_START_BIT)

#define AW88081_HMUTE_START_BIT	(8)
#define AW88081_HMUTE_BITS_LEN		(1)
#define AW88081_HMUTE_MASK		\
	(~(((1<<AW88081_HMUTE_BITS_LEN)-1) << AW88081_HMUTE_START_BIT))

#define AW88081_HMUTE_DISABLE		(0)
#define AW88081_HMUTE_DISABLE_VALUE	\
	(AW88081_HMUTE_DISABLE << AW88081_HMUTE_START_BIT)

#define AW88081_HMUTE_ENABLE		(1)
#define AW88081_HMUTE_ENABLE_VALUE	\
	(AW88081_HMUTE_ENABLE << AW88081_HMUTE_START_BIT)

#define AW88081_EN_PA_START_BIT	(1)
#define AW88081_EN_PA_BITS_LEN		(1)
#define AW88081_EN_PA_MASK		\
	(~(((1<<AW88081_EN_PA_BITS_LEN)-1) << AW88081_EN_PA_START_BIT))

#define AW88081_EN_PA_WORKING		(1)
#define AW88081_EN_PA_WORKING_VALUE	\
	(AW88081_EN_PA_WORKING << AW88081_EN_PA_START_BIT)

#define AW88081_EN_PA_POWER_DOWN	(0)
#define AW88081_EN_PA_POWER_DOWN_VALUE	\
	(AW88081_EN_PA_POWER_DOWN << AW88081_EN_PA_START_BIT)

#define AW88081_PWDN_START_BIT		(0)
#define AW88081_PWDN_BITS_LEN		(1)
#define AW88081_PWDN_MASK		\
	(~(((1<<AW88081_PWDN_BITS_LEN)-1) << AW88081_PWDN_START_BIT))

#define AW88081_PWDN_WORKING		(0)
#define AW88081_PWDN_WORKING_VALUE	\
	(AW88081_PWDN_WORKING << AW88081_PWDN_START_BIT)

#define AW88081_PWDN_POWER_DOWN	(1)
#define AW88081_PWDN_POWER_DOWN_VALUE	\
	(AW88081_PWDN_POWER_DOWN << AW88081_PWDN_START_BIT)

#define AW88081_VOL_START_BIT		(0)
#define AW88081_VOL_BITS_LEN		(10)
#define AW88081_VOL_MASK		\
	(~(((1<<AW88081_VOL_BITS_LEN)-1) << AW88081_VOL_START_BIT))

#define AW88081_VOLUME_STEP_DB		(64)
#define AW88081_MUTE_VOL		(1023)

#define AW88081_I2STXEN_START_BIT	(6)
#define AW88081_I2STXEN_BITS_LEN	(1)
#define AW88081_I2STXEN_MASK		\
	(~(((1<<AW88081_I2STXEN_BITS_LEN)-1) << AW88081_I2STXEN_START_BIT))

#define AW88081_I2STXEN_DISABLE	(0)
#define AW88081_I2STXEN_DISABLE_VALUE	\
	(AW88081_I2STXEN_DISABLE << AW88081_I2STXEN_START_BIT)

#define AW88081_I2STXEN_ENABLE		(1)
#define AW88081_I2STXEN_ENABLE_VALUE	\
	(AW88081_I2STXEN_ENABLE << AW88081_I2STXEN_START_BIT)

#define AW88081_NOISE_GATE_EN_START_BIT	(13)
#define AW88081_NOISE_GATE_EN_BITS_LEN	(1)
#define AW88081_NOISE_GATE_EN_MASK	\
		(~(((1<<AW88081_NOISE_GATE_EN_BITS_LEN)-1) << AW88081_NOISE_GATE_EN_START_BIT))

#define AW88081_NOISE_GATE_EN_DISABLE	(0)
#define AW88081_NOISE_GATE_EN_DISABLE_VALUE	\
		(AW88081_NOISE_GATE_EN_DISABLE << AW88081_NOISE_GATE_EN_START_BIT)

#define AW88081_NOISE_GATE_EN_ENABLE	(1)
#define AW88081_NOISE_GATE_EN_ENABLE_VALUE	\
		(AW88081_NOISE_GATE_EN_ENABLE << AW88081_NOISE_GATE_EN_START_BIT)

#define AW88081_CCO_MUX_START_BIT	(13)
#define AW88081_CCO_MUX_BITS_LEN	(1)
#define AW88081_CCO_MUX_MASK		\
	(~(((1<<AW88081_CCO_MUX_BITS_LEN)-1) << AW88081_CCO_MUX_START_BIT))

#define AW88081_CCO_MUX_DIVIDED	(0)
#define AW88081_CCO_MUX_DIVIDED_VALUE	\
	(AW88081_CCO_MUX_DIVIDED << AW88081_CCO_MUX_START_BIT)

#define AW88081_CCO_MUX_BYPASS		(1)
#define AW88081_CCO_MUX_BYPASS_VALUE	\
	(AW88081_CCO_MUX_BYPASS << AW88081_CCO_MUX_START_BIT)

#define AW88083_I2C_WEN_START_BIT	(14)
#define AW88083_I2C_WEN_BITS_LEN	(2)
#define AW88083_I2C_WEN_MASK		\
	(~(((1<<AW88083_I2C_WEN_BITS_LEN)-1) << AW88083_I2C_WEN_START_BIT))

#define AW88083_I2C_WEN_DISABLE	(0)
#define AW88083_I2C_WEN_DISABLE_VALUE	\
	(AW88083_I2C_WEN_DISABLE << AW88083_I2C_WEN_START_BIT)

#define AW88083_I2C_WEN_ENABLE		(2)
#define AW88083_I2C_WEN_ENABLE_VALUE	\
	(AW88083_I2C_WEN_ENABLE << AW88083_I2C_WEN_START_BIT)

#define AW88083_PLL_PD_START_BIT	(2)
#define AW88083_PLL_PD_BITS_LEN	(1)
#define AW88083_PLL_PD_MASK		\
	(~(((1<<AW88083_PLL_PD_BITS_LEN)-1) << AW88083_PLL_PD_START_BIT))

#define AW88083_PLL_PD_POWER_DOWN	(1)
#define AW88083_PLL_PD_POWER_DOWN_VALUE	\
	(AW88083_PLL_PD_POWER_DOWN << AW88083_PLL_PD_START_BIT)

#define AW88083_PLL_PD_WORKING		(0)
#define AW88083_PLL_PD_WORKING_VALUE	\
	(AW88083_PLL_PD_WORKING << AW88083_PLL_PD_START_BIT)

#define AW88083_AMPPD_START_BIT	(1)
#define AW88083_AMPPD_BITS_LEN		(1)
#define AW88083_AMPPD_MASK		\
	(~(((1<<AW88083_AMPPD_BITS_LEN)-1) << AW88083_AMPPD_START_BIT))

#define AW88083_AMPPD_WORKING		(0)
#define AW88083_AMPPD_WORKING_VALUE	\
	(AW88083_AMPPD_WORKING << AW88083_AMPPD_START_BIT)

#define AW88083_AMPPD_POWER_DOWN	(1)
#define AW88083_AMPPD_POWER_DOWN_VALUE	\
	(AW88083_AMPPD_POWER_DOWN << AW88083_AMPPD_START_BIT)

#define AW88083_REG_MAX		(0x7D)
#define AW88083_I2C_NAME		"aw88083"
#define AW88083_CHIP_ID		0x2407

#define AW88081_START_RETRIES		(5)
#define AW88081_START_WORK_DELAY_MS	(0)

#define AW88081_I2C_NAME		"aw88081"
#define AW88081_CHIP_ID		0x2116

#define AW88081_RATES (SNDRV_PCM_RATE_8000_48000 | \
			SNDRV_PCM_RATE_96000)
#define AW88081_FORMATS (SNDRV_PCM_FMTBIT_S16_LE | \
			SNDRV_PCM_FMTBIT_S24_LE | \
			SNDRV_PCM_FMTBIT_S32_LE)

#define FADE_TIME_MAX			100000

#define AW88081_DEV_DEFAULT_CH		(0)
#define AW88081_ACF_FILE		"/*(DEBLOBBED)*/"
#define AW88081_DEV_SYSST_CHECK_MAX	(10)
#define AW88081_SOFT_RESET_VALUE	(0x55aa)

#define AW88081_INIT_PROFILE		(0)

#define AW88081_PROFILE_EXT(xname, profile_info, profile_get, profile_set) \
{ \
	.iface = SNDRV_CTL_ELEM_IFACE_MIXER, \
	.name = xname, \
	.info = profile_info, \
	.get = profile_get, \
	.put = profile_set, \
}

enum {
	AW88081_SYNC_START = 0,
	AW88081_ASYNC_START,
};

enum {
	AW88081_500_US = 500,
	AW88081_1000_US = 1000,
	AW88081_2000_US = 2000,
	AW88081_5000_US = 5000,
};

enum {
	AW88081_DEV_PW_OFF = 0,
	AW88081_DEV_PW_ON,
};

enum {
	AW88081_DEV_FW_FAILED = 0,
	AW88081_DEV_FW_OK,
};

#endif
